// File: controllers/RefreshToken.js
import Users from "../models/userModel.js";
import jwt from "jsonwebtoken";

export const refreshToken = async (req, res) => {
  try {
    // Ambil refresh token dari cookie, header, atau body
    const refreshToken =
      req.cookies.refreshToken ||
      req.body.refreshToken ||
      req.headers.cookie?.split("refreshToken=")[1]?.split(";")[0];

    console.log("RefreshToken: Received token:", refreshToken);

    if (!refreshToken) {
      console.log("RefreshToken: No token provided");
      return res.status(401).json({ msg: "Refresh token tidak ditemukan" });
    }

    // Cari user berdasarkan refresh token
    const user = await Users.findAll({
      where: {
        refresh_token: refreshToken,
      },
    });

    if (!user[0]) {
      console.log("RefreshToken: User not found");
      return res.status(403).json({ msg: "Refresh token tidak valid" });
    }

    // Verifikasi refresh token
    jwt.verify(refreshToken, process.env.JWT_REFRESH_SECRET, (err, decoded) => {
      if (err) {
        console.log("RefreshToken: Verification error:", err.message);
        return res
          .status(403)
          .json({ msg: "Refresh token tidak valid atau kedaluwarsa" });
      }

      const userId = user[0].id;
      const name = user[0].name;
      const nohp = user[0].no_hp;

      // Buat access token baru
      const accessToken = jwt.sign(
        { userId, name, nohp },
        process.env.JWT_SECRET,
        {
          expiresIn: "15m", // Durasi 15 menit
        }
      );

      // Kirim access token baru
      res.json({ accessToken });
    });
  } catch (error) {
    console.log("RefreshToken error:", error);
    res.status(500).json({ msg: "Internal Server Error" });
  }
};
