import express from "express";
import db from "./config/database.js";
import cors from "cors";
import cookieParser from "cookie-parser";
import router from "./routes/index.js";
import dotenv from "dotenv";
// Model tidak perlu di-sync di produksi, jadi bisa saja dihapus jika tidak digunakan di tempat lain di file ini
// import Users from "./models/userModel.js";
// import RefreshTokens from "./models/refreshTokenModel.js";
// ... dan seterusnya

dotenv.config();

// Hapus console.log ini di produksi untuk menjaga log tetap bersih
// console.log("JWT_SECRET:", process.env.JWT_SECRET ? "Defined" : "Undefined");
// console.log("JWT_REFRESH_SECRET:", process.env.JWT_REFRESH_SECRET ? "Defined" : "Undefined");
// console.log("NODE_ENV:", process.env.NODE_ENV || "Not set");

const app = express();

try {
  await db.authenticate();
  console.log("Database connected");
  // PERUBAHAN 3: Hapus atau komentari semua perintah .sync() di produksi
  // await Users.sync({ force: false });
  // await RefreshTokens.sync({ force: false });
  // await DataPeserta.sync({ force: false });
  // await DataEvent.sync({ force: false });
  // await DataBurung.sync({ force: false });
} catch (error) {
  console.error("Database error:", error);
}

// PERUBAHAN 2: Konfigurasi CORS yang dinamis dan aman
const whitelist = [
  "http://localhost:3000", // Untuk development frontend lokal
  "https://pomp-gbsb-purbalingga.it.com", // Ganti dengan domain frontend produksi Anda
  "https://app.pomp-gbsb-purbalingga.it.com", // Ganti dengan domain admin produksi Anda
];

const corsOptions = {
  credentials: true,
  origin: function (origin, callback) {
    // Izinkan jika origin ada di whitelist atau jika origin tidak ada (misal: request dari Postman)
    if (whitelist.indexOf(origin) !== -1 || !origin) {
      callback(null, true);
    } else {
      callback(new Error("Not allowed by CORS"));
    }
  },
};

app.use(cors(corsOptions));
app.use(cookieParser());
app.use(express.json());
app.use(router);

// PERUBAHAN 4: Tambahkan middleware untuk penanganan error
app.use((err, req, res, next) => {
  console.error(err.stack); // Selalu log error detail di server
  res.status(500).send({ message: "Terjadi kesalahan pada server." });
});

// PERUBAHAN 1: Gunakan port dari environment variable
const port = process.env.PORT || 5000;
app.listen(port, () => console.log(`Server running at port ${port}`));
