import jwt from "jsonwebtoken";

const verifyToken = (req, res, next) => {
  const token = req.cookies.accessToken;
  if (!token) {
    console.log("No access token found in cookies");
    return res
      .status(401)
      .json({ msg: "Akses ditolak, token tidak ditemukan" });
  }

  try {
    const decoded = jwt.verify(token, process.env.JWT_SECRET);
    console.log("Decoded token:", decoded);
    req.user = {
      userId: decoded.userId,
      nohp: decoded.nohp,
      role: decoded.role,
    };
    next();
  } catch (error) {
    console.error("Token verification failed:", error);
    return res.status(403).json({ msg: "Token tidak valid" });
  }
};

export default verifyToken;
