"use strict";

/** @type {import('sequelize-cli').Migration} */
module.exports = {
  async up(queryInterface, Sequelize) {
    // Tambahkan kolom SEX
    await queryInterface.addColumn("data_burung", "sex", {
      type: Sequelize.STRING(10),
      allowNull: true,
      defaultValue: null,
      comment: "Jenis kelamin burung (Male/Female)",
    });

    // Tambahkan kolom COL
    await queryInterface.addColumn("data_burung", "col", {
      type: Sequelize.STRING(50),
      allowNull: true,
      defaultValue: null,
      comment: "Kolom tambahan untuk data burung",
    });
  },

  async down(queryInterface, Sequelize) {
    await queryInterface.removeColumn("data_burung", "sex");
    await queryInterface.removeColumn("data_burung", "col");
  },
};
