import { Sequelize } from "sequelize";
import db from "../config/database.js";
import DataEvent from "./dataEventModel.js";

const { DataTypes } = Sequelize;

const Race = db.define(
  "races", // Nama tabel di database
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    event_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: DataEvent,
        key: "id",
      },
    },
    race_number: { type: DataTypes.INTEGER, allowNull: false },
    race_name: { type: DataTypes.STRING, allowNull: true },
    // KOLOM BARU SESUAIKAN DENGAN RaceSetup.tsx
    race_status: { type: DataTypes.STRING, allowNull: true },
    kota_race: { type: DataTypes.STRING, allowNull: true },
    kelas_race: { type: DataTypes.STRING, allowNull: true },
    rangking_etape: { type: DataTypes.STRING, allowNull: true },
    kecepatan_minimal: { type: DataTypes.DECIMAL(10, 2), allowNull: true },
    pinalti_basketing: { type: DataTypes.DECIMAL(10, 2), allowNull: true },
    pinalti_clock: { type: DataTypes.DECIMAL(10, 2), allowNull: true },
    tanggal_inkorf: { type: DataTypes.DATEONLY, allowNull: true },
    tanggal_tutup: { type: DataTypes.DATEONLY, allowNull: true },
    jam_lepas: { type: DataTypes.TIME, allowNull: true },
    jam_buka_clock: { type: DataTypes.TIME, allowNull: true },
    jam_tutup_clock: { type: DataTypes.TIME, allowNull: true },
    jam_tutup_race: { type: DataTypes.TIME, allowNull: true },
    // Kolom yang sudah ada
    distance_km: { type: DataTypes.DECIMAL(10, 2), allowNull: true },
    description: { type: DataTypes.TEXT, allowNull: true },
    created_at: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    updated_at: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    latitude: {
      type: DataTypes.DOUBLE, // atau FLOAT, atau DECIMAL(10, 8)
      allowNull: true,
    },
    longitude: {
      type: DataTypes.DOUBLE, // atau FLOAT, atau DECIMAL(11, 8)
      allowNull: true,
    },
  },
  {
    freezeTableName: true,
    timestamps: false,
  }
);

DataEvent.hasMany(Race, { foreignKey: "event_id", onDelete: "CASCADE" });
Race.belongsTo(DataEvent, { foreignKey: "event_id" });

export default Race;
