// models/RaceRegistrationModel.js
import { Sequelize } from "sequelize";
import db from "../config/database.js";
import Race from "./RaceModel.js";
import DataBurung from "./dataBurungModel.js"; // Pastikan import ini benar
import Users from "./userModel.js";

const { DataTypes } = Sequelize;

const RaceRegistration = db.define(
  "race_registrations",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    race_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: Race,
        key: "id",
      },
    },
    bird_id: {
      type: DataTypes.INTEGER, // Tetap INTEGER
      allowNull: false,
      references: {
        model: DataBurung,
        key: "id",
      },
    },
    bird_name: {
      // KOLOM BARU DI MODEL
      type: DataTypes.STRING,
      allowNull: false, // Atau true jika Anda mengizinkan NULL
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: Users,
        key: "id",
      },
    },
    registration_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    status: { type: DataTypes.STRING, defaultValue: "registered" },
    created_at: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    updated_at: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
  },
  {
    freezeTableName: true,
    timestamps: false,
    indexes: [
      {
        unique: true,
        fields: ["race_id", "bird_id"],
      },
    ],
  }
);

Race.hasMany(RaceRegistration, { foreignKey: "race_id", onDelete: "CASCADE" });
RaceRegistration.belongsTo(Race, { foreignKey: "race_id" });

DataBurung.hasMany(RaceRegistration, {
  foreignKey: "bird_id",
  onDelete: "CASCADE",
});
RaceRegistration.belongsTo(DataBurung, { foreignKey: "bird_id" });

Users.hasMany(RaceRegistration, { foreignKey: "user_id", onDelete: "CASCADE" });
RaceRegistration.belongsTo(Users, { foreignKey: "user_id" });

export default RaceRegistration;
