import { Sequelize } from "sequelize";
import db from "../config/database.js";
import Users from "./userModel.js";

const { DataTypes } = Sequelize;

const DataBurung = db.define(
  "data_burung",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: Users,
        key: "id",
      },
    },
    bird_name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    COL: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    SEX: {
      type: DataTypes.STRING,
      allowNull: true,
    },
  },
  {
    freezeTableName: true,
    timestamps: true,
  }
);

Users.hasMany(DataBurung, { foreignKey: "user_id" });
DataBurung.belongsTo(Users, { foreignKey: "user_id", onDelete: "CASCADE" });

export default DataBurung;
