import { Sequelize } from "sequelize";
import db from "../config/database.js";

const { DataTypes } = Sequelize;

const DataEvent = db.define(
  "dataevent",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    event_name: {
      type: DataTypes.STRING,
    },
    season: {
      type: DataTypes.STRING,
    },
    club_id: {
      type: DataTypes.STRING,
    },
    club_name: {
      type: DataTypes.STRING,
    },
    time_schedule: {
      type: DataTypes.STRING,
    },
    race_status: {
      type: DataTypes.STRING,
    },
    race_count: {
      type: DataTypes.INTEGER,
    },
    ranking_total_pos: {
      type: DataTypes.INTEGER,
    },
    radius_clock: {
      type: DataTypes.FLOAT,
    },
  },
  {
    freezeTableName: true,
    timestamps: true,
  }
);

export default DataEvent;
