import { Sequelize } from "sequelize";
import db from "../config/database.js";
import Users from "./userModel.js";

const { DataTypes } = Sequelize;

const DataPeserta = db.define(
  "data_peserta",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    no_hp: {
      type: DataTypes.STRING,
      allowNull: false,
      references: {
        model: Users,
        key: "no_hp",
      },
    },
    nama_peserta: { type: DataTypes.STRING },
    nama_kandang: { type: DataTypes.STRING },
    alamat: { type: DataTypes.STRING },
    kota_kabupaten: { type: DataTypes.STRING },
    provinsi: { type: DataTypes.STRING },
    club: { type: DataTypes.STRING },
    latitude: { type: DataTypes.DOUBLE },
    longitude: { type: DataTypes.DOUBLE },
  },
  {
    freezeTableName: true,
    timestamps: true,
  }
);

Users.hasOne(DataPeserta, {
  foreignKey: "no_hp",
  sourceKey: "no_hp",
  as: "data_peserta",
  onDelete: "CASCADE",
});
DataPeserta.belongsTo(Users, {
  foreignKey: "no_hp",
  targetKey: "no_hp",
  as: "user",
});

export default DataPeserta;
